﻿using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Update
{
    /// <summary>
    /// Get Integration Settings step.
    /// </summary>
    public class GetIntegrationSettingsStep : FilterBase<VideoVisitUpdateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitUpdateStateObject state)
        {
            using (var context = new Xrm(state.OrganizationServiceProxy))
            {
                var useFakeResponse = context.mcs_integrationsettingSet.FirstOrDefault(x => x.mcs_name == "Vista Fake Response Type");
                state.FakeResponseType = useFakeResponse == null ? string.Empty : useFakeResponse.mcs_value;
            }
        }
    }
}